/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	Note.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CDrawing.h"
#include "CApplication.h"


HRESULT Note(IDesign *pDesign, IDrawingDocument *pDrawingDoc, IGraphic *pGraph1, INote **note)
{
	//	Creates a Note
	START_METHOD("Note")

	HRESULT status = CONV_SUCCESS;

	CHECK_VAR_STATUS(pDrawingDoc)

	IDrawingDocOthers *doc1 = CAST(IDrawingDocOthers, pDrawingDoc);

	IDrawingDocument *activeDoc = CAST(IDrawingDocument, pDrawingDoc);

	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, activeDoc);

	IDrawing *localDraw= NULL;
	status = activeDoc->GetDrawing(&localDraw);
	CHECK_RETURN_STATUS(status)

	IDesignDetail *pDisp2 = NULL;
	status = localDraw->GetDetail(pDesign, FALSE, &pDisp2);
	CHECK_RETURN_STATUS(status)

	IGeometry *pGeom = NULL;
	status = activeDoc->GetPaperGeometry(pGraph1, &pGeom);
	CHECK_RETURN_STATUS(status)

	CString str1 = " Note ";

	INote *pNote = NULL;
	status = (GetCLASS(Note))->CreateNote(localDraw, str1.AllocSysString(), &pNote);
	CHECK_RETURN_STATUS(status)

	*note = pNote;

	INoteCallout *noteCallout = NULL;
	status = (GetCLASS(NoteCallout))->CreateNoteCallout(pNote, &noteCallout);
	CHECK_RETURN_STATUS(status)

	status = pNote->SetText(str1.AllocSysString());
	CHECK_RETURN_STATUS(status)

	IVector *textLocation2 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.1, 0.2, 0, &textLocation2);
	CHECK_RETURN_STATUS(status)

	ICalloutGroup *calloutGroup = NULL;
	status = (GetCLASS(CalloutGroup))->CreateCalloutGroup(CAST(ICallout, noteCallout), textLocation2, 0.005, &calloutGroup);
	CHECK_RETURN_STATUS(status)

	status = calloutGroup->SetControlPoint(1, textLocation2);
	CHECK_RETURN_STATUS(status)

	status = noteCallout->SetBoxed(TRUE);
	CHECK_RETURN_STATUS(status)

	// Get the active sheet in current drawing
	ISheet *pSheet = NULL;
	status = pDrawingDoc->GetActiveSheet(&pSheet);
	CHECK_RETURN_STATUS(status)


	status = pSheet->AddCalloutGroup(calloutGroup);
	CHECK_RETURN_STATUS(status)

	IFeatureLeader *pLeader = NULL;
	status = (GetCLASS(FeatureLeader))->CreateFeatureLeader(calloutGroup, pGeom, &pLeader);
	CHECK_RETURN_STATUS(status)

	status = pSheet->AddLeader(CAST(ILeader, pLeader));
	CHECK_RETURN_STATUS(status)

	// Add center line
	// To be done

	END_METHOD("Note")
}
